<?php
/*
* Plugin Name: CodingDude jQuery Shortcode for WordPress
* Description: WordPress shortcode for using jQuery plugins inside posts and pages
* Version: 1.0
* Author: @codingdudecom
* Author URI: https://www.coding-dude.com
*/


/** adding Settings > menu entry **/
add_action( 'admin_menu', 'codingdude_jquery_custom_admin_menu' );
 
function codingdude_jquery_custom_admin_menu() {
	
    add_options_page(
        'jQuery Shortcode',
        'jQuery Shortcode',
        'manage_options',
        'codingdude-jquery-plugin',
        'codingdude_jquery_options_page'
    );
}


/** Plugin settings screen **/
function codingdude_jquery_options_page(){
    ?>
    <div class="wrap">
    	<form method="post" action="options.php">
	        <h2>jQuery Shortcode Options</h2>
	        
	        <?php 
	        	settings_fields( 'codingdude-jquery' ); 
	        	do_settings_sections( 'codingdude-jquery' );
	        ?>
	        
	        <label for="js_file">
	        	<b>Path to jQuery Plugin JS file(s):</b>
	        	<br>
	        	<i>separate files paths using commas</i>
	        </label>
	        <p>
	        <textarea placeholder=".../jQuery.pluginName.min.js" name="js_file"  rows="5" cols="70"
	        ><?php echo esc_attr( get_option('js_file') ); ?></textarea>
	        </p>
			<?php submit_button(); ?>
    	</form>
    </div>
    <?php
}


/** Registering plugin settings option **/
function codingdude_jquery_register_options(){
	register_setting( 'codingdude-jquery', 'js_file' );
}

if ( is_admin() ){ // admin actions
  add_action( 'admin_init', 'codingdude_jquery_register_options' );
} else {
  
}



/** Using the plugin settings option **/
function script_that_requires_jquery() {


	$jsfile = get_option('js_file');

	if (!empty($jsfile)){
		if (strpos($jsfile, ',') !== false) {
			$jsfile_arr = explode(',', $jsfile);
			foreach($jsfile_arr as $key => $value){
				wp_register_script( 'codingdude-jquery-plugin-'.$key, trim($value), array( 'jquery' ), '1.0.0', true );
		    	wp_enqueue_script( 'codingdude-jquery-plugin-'.$key );    
			}
		} else {
		    wp_register_script( 'codingdude-jquery-plugin', $jsfile, array( 'jquery' ), '1.0.0', true );
		    wp_enqueue_script( 'codingdude-jquery-plugin' );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'script_that_requires_jquery' );



/** Shodrtcode definition **/
function codingdude_jquery($atts, $content = null){
	$a = shortcode_atts( array(
        'selector' => null,
        'name' => null
    	), $atts );

	if (empty($a['selector']) || empty($a['name']))
	{
		ob_start();
	?>
		<script type="text/javascript">
		jQuery(document).ready(
			function($){
			<?php echo html_entity_decode(strip_tags($content, '<br/>')) ?>
			}
		);
		</script>
	<?php
		return ob_get_clean();
	} else {

		ob_start();
	?>
		<script type="text/javascript">
		jQuery(document).ready(
			function($){
				var doPlugin = function (){
					$("<?php echo $a['selector']; ?>").<?php echo $a['name']; ?>(
						{
							<?php echo html_entity_decode(strip_tags($content, '<br/>')) ?>
						});
				}

				var attempt = function(){
					if ($("<?php echo $a['selector']; ?>").length > 0){
						doPlugin();
					} else {
						setTimeout(attempt,1000);
					}
				};

				setTimeout(attempt, 1000);
			}
		);
		</script>
	<?php
		return ob_get_clean();
	}
}
add_shortcode('jquery', 'codingdude_jquery');



/** add Settings link **/
add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'coding_dude_jquery_add_action_links' );

function coding_dude_jquery_add_action_links ( $links ) {
 $mylinks = array(
 '<a href="' . admin_url( 'options-general.php?page=codingdude-jquery-plugin' ) . '">Settings</a>',
 //'<a href="http://www.coding-dude.com">Author Website</a>',
 );
return array_merge( $links, $mylinks );
}



/**Exclude shortcode from wptexturizer to avoid changing quotation marks **/

add_filter( 'no_texturize_shortcodes', 'codingdude_jquery_shortcodes_to_exempt_from_wptexturize' );
function codingdude_jquery_shortcodes_to_exempt_from_wptexturize( $shortcodes ) {
    $shortcodes[] = 'jquery';
    return $shortcodes;
}


?>